#!/usr/bin/python

import math
import numpy as np
import matplotlib.pyplot as plt
import matplotlib.gridspec as gridspec
import os

def get_spec(eL_eV, eH_eV, num_ps, energy_ev, strength, sigma_eV):
    e_eV = np.linspace(eL_eV, eH_eV, num_ps)
    epsilon_Lrmolrcm = np.zeros(e_eV.size)
    C = 1.3062974E+8 
    for i, _ in enumerate(e_eV):
        epsilon_Lrmolrcm[i] = (strength*np.exp(-((e_eV[i]-energy_eV)/sigma_eV)**2)).sum()/sigma_eV*C
    return e_eV, epsilon_Lrmolrcm

if __name__ == "__main__":
    fn = "x-C-XAS.txt"
    eL_eV = 286
    eH_eV = 293    
    sigma_eV = 0.2
    num_ps = 500
    use_angle = True 
    incident_angles = [i*30 for i in range(4)]
    
    # You do NOT need to modify things below.
    if use_angle:
        data = np.loadtxt(fn, delimiter = ',', usecols =[2,3,4,5,6], skiprows=1).transpose()
        energy_eV = data[0] 
        f = data[1]    
        dmx = data[2]
        dmy = data[3]
        dmz = data[4]
        for ti in incident_angles:
            cosei = math.cos(ti*math.pi/180.)
            cos2ei = cosei*cosei
            sin2ei = 1-cos2ei                
            f_eff = f.copy()
            for i in range(len(f)):                
                cos2et =(dmx[i]*dmx[i]+dmy[i]*dmy[i])/(dmx[i]*dmx[i]+dmy[i]*dmy[i]+dmz[i]*dmz[i])
                sin2et = 1-cos2et                
                eff = 0.5*sin2ei*sin2et+cos2ei*cos2et
                f_eff[i] = f_eff[i]*eff
            e_eV, epsilon_Lrmolrcm = get_spec(eL_eV, eH_eV, num_ps, energy_eV, f_eff, sigma_eV)
            plt.plot(e_eV, epsilon_Lrmolrcm, "-", label = str(ti))
            plt.legend()
              
    else:
        data = np.loadtxt(fn, delimiter = ',', usecols =[2,3], skiprows=1).transpose()
        energy_eV = data[0] 
        f = data[1]    
        e_eV, epsilon_Lrmolrcm = get_spec(eL_eV, eH_eV, num_ps, energy_eV, f, sigma_eV)
        plt.plot(e_eV, epsilon_Lrmolrcm, "-")    
    plt.xlabel("Energy (eV)")
    plt.ylabel("Strength (L/mol/cm)")
    plt.show()